% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svd.r
\docType{methods}
\name{svd}
\alias{svd}
\alias{La.svd,float32-method}
\alias{svd,float32-method}
\title{SVD}
\usage{
\S4method{La.svd}{float32}(x, nu = min(n, p), nv = min(n, p))

\S4method{svd}{float32}(x, nu = min(n, p), nv = min(n, p),
  LINPACK = FALSE)
}
\arguments{
\item{x}{A float matrix.}

\item{nu, nv}{The number of left/right singular vectors to return.}

\item{LINPACK}{Ignored}
}
\description{
SVD factorization.
}
\details{
The factorization is performed by the LAPACK routine \code{sgesdd()}.
}
\examples{
library(float)

x = flrunif(10, 3)
svd(x)

}
