% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_flights.R
\name{read_flights}
\alias{read_flights}
\title{Download flight data from Brazil}
\usage{
read_flights(year = 2020, month = 1, type = "basica", showProgress = TRUE)
}
\arguments{
\item{year}{Numeric. Year of the data. Defaults to \code{2010}}

\item{month}{Numeric. Year of the data. Defaults to \code{1} (January)}

\item{type}{String. Whether the data set should be of the type \code{basica}
(flight stage, the default) or \code{combinada} (On flight origin and destination
\itemize{
\item OFOD).
}}

\item{showProgress}{Logical. Defaults to \code{TRUE} display progress bar}
}
\value{
A \verb{"data.table" "data.frame"} object
}
\description{
Download flight data from Brazil’s Civil Aviation Agency (ANAC). The data
includes detailed information on every international flight to and from Brazil,
as well as domestic flights within the country. The data include flight-level
information of airports of origin and destination, flight duration, aircraft
type, payload, and the number of passengers, and several other variables. A
description of all variables included in the data is available at \url{https://www.anac.gov.br/assuntos/setor-regulado/empresas/envio-de-informacoes/descricao-de-variaveis}.
}
\examples{
\dontrun{ if (interactive()) {
# Read flights data
a201506 <- read_flights(year=2015, month=6)
}}
}
\concept{download flight data}
