% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunk_images.R
\name{grid_chunk}
\alias{grid_chunk}
\title{'Grid Graphics' chunk wrapper}
\usage{
grid_chunk(value, width = 1, height = 0.2, unit = "in", res = 300)
}
\arguments{
\item{value}{grid objects, stored in a list column; or a list
of grid objects.}

\item{width, height}{size of the resulting png file}

\item{unit}{unit for width and height, one of "in", "cm", "mm".}

\item{res}{resolution of the png image in ppi}
}
\description{
This function is used to insert grid objects into
flextable with functions:
\itemize{
\item \code{\link[=compose]{compose()}} and \code{\link[=as_paragraph]{as_paragraph()}},
\item \code{\link[=append_chunks]{append_chunks()}},
\item \code{\link[=prepend_chunks]{prepend_chunks()}}.
}
}
\note{
This chunk option requires package officedown in a R Markdown
context with Word output format.

PowerPoint cannot mix images and text in a paragraph, images
are removed when outputing to PowerPoint format.
}
\examples{
library(flextable)
ft_1 <- flextable(head(cars))
if(require("grid")){
  ft_1 <- prepend_chunks(
    x = ft_1, i = 2, j = 2,
    grid_chunk(
      list(
        grid.circle(gp = gpar(fill="#ec11c2",
          col = "transparent"))),
      width = .15, height = .15)
  )
}
ft_1
}
\seealso{
Other chunk elements for paragraph: 
\code{\link{as_bracket}()},
\code{\link{as_b}()},
\code{\link{as_chunk}()},
\code{\link{as_equation}()},
\code{\link{as_highlight}()},
\code{\link{as_image}()},
\code{\link{as_i}()},
\code{\link{as_sub}()},
\code{\link{as_sup}()},
\code{\link{as_word_field}()},
\code{\link{colorize}()},
\code{\link{gg_chunk}()},
\code{\link{hyperlink_text}()},
\code{\link{linerange}()},
\code{\link{lollipop}()},
\code{\link{minibar}()},
\code{\link{plot_chunk}()}
}
\concept{chunk elements for paragraph}
