% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printers.R
\name{save_as_image}
\alias{save_as_image}
\title{save a flextable as an image}
\usage{
save_as_image(x, path, zoom = 3, expand = 10, webshot = "webshot")
}
\arguments{
\item{x}{a flextable object}

\item{path}{image file to be created. It should end with .png, .pdf, or .jpeg.}

\item{zoom, expand}{parameters used by \code{webshot} function.}

\item{webshot}{webshot package as a scalar character, one of "webshot" or
"webshot2".}
}
\description{
save a flextable as a png, pdf or jpeg image.

Image generated with package 'webshot' or package 'webshot2'.
\strong{Package 'webshot2' should be prefered} as 'webshot' can have
issues with some properties (i.e. bold are not rendered for some users).
}
\note{
This function requires package webshot or webshot2.
}
\examples{
ft <- flextable( head( mtcars ) )
ft <- autofit(ft)
tf <- tempfile(fileext = ".png")
\dontrun{
if( require("webshot") ){
  save_as_image(x = ft, path = "myimage.png")
}
}
}
\seealso{
Other flextable print function: 
\code{\link{as_raster}()},
\code{\link{df_printer}()},
\code{\link{flextable_to_rmd}()},
\code{\link{htmltools_value}()},
\code{\link{knit_print.flextable}()},
\code{\link{plot.flextable}()},
\code{\link{print.flextable}()},
\code{\link{save_as_docx}()},
\code{\link{save_as_html}()},
\code{\link{save_as_pptx}()}
}
\concept{flextable print function}
