% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printers.R
\name{htmltools_value}
\alias{htmltools_value}
\title{flextable as an HTML object}
\usage{
htmltools_value(x, ft.align = "center", ft.shadow = TRUE)
}
\arguments{
\item{x}{a flextable object}

\item{ft.align}{flextable alignment, supported values are 'left', 'center' and 'right'.}

\item{ft.shadow}{use shadow dom, this option is existing
to disable shadow dom (set to \code{FALSE}) for pagedown that can not support it for now.}
}
\value{
an object marked as \link{HTML} ready to be used within
a call to \code{shiny::renderUI} for example.
}
\description{
get a \code{\link[=div]{div()}} from a flextable object.
This can be used in a shiny application. For an output within
"R Markdown" document, use \link{knit_print.flextable}.
}
\examples{
htmltools_value(flextable(iris[1:5,]))
}
\seealso{
Other flextable print function: 
\code{\link{as_raster}()},
\code{\link{df_printer}()},
\code{\link{flextable_to_rmd}()},
\code{\link{knit_print.flextable}()},
\code{\link{plot.flextable}()},
\code{\link{print.flextable}()},
\code{\link{save_as_docx}()},
\code{\link{save_as_html}()},
\code{\link{save_as_image}()},
\code{\link{save_as_pptx}()}
}
\concept{flextable print function}
