% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable.R
\name{set_caption}
\alias{set_caption}
\title{Set Caption}
\usage{
set_caption(
  x,
  caption,
  autonum = NULL,
  style = "Table Caption",
  html_escape = TRUE
)
}
\arguments{
\item{x}{flextable object}

\item{caption}{caption value}

\item{autonum}{an autonum representation. See \code{\link[officer:run_autonum]{officer::run_autonum()}}.
This has only an effect when output is Word. If used, the caption is preceded
by an auto-number sequence. In this case, the caption is preceded by an auto-number
sequence that can be cross referenced.}

\item{style}{caption paragraph style name. These names are available with
function \code{\link[officer:styles_info]{officer::styles_info()}} when output is Word; if HTML, the
value is set as class value in the \code{caption} tag.}

\item{html_escape}{should HTML entities be escaped so that it can be safely
included as text or an attribute value within an HTML document.}
}
\description{
Set caption value in a flextable.
\itemize{
\item The caption will be associated with a paragraph style when
the output is Word. Also it can be numbered as a auto-numbered
Word computed value.
\item In HTML and PDF, the style of the caption
is managed at the document level and not with flextable.
\item The PowerPoint format ignores captions.
}
}
\examples{
ftab <- flextable( head( iris ) )
ftab <- set_caption(ftab, "my caption")
ftab

library(officer)
autonum <- run_autonum(seq_id = "tab", bkm = "mtcars")
ftab <- flextable( head( mtcars ) )
ftab <- set_caption(ftab, caption = "mtcars data", autonum = autonum)
ftab
}
\seealso{
\code{\link[=flextable]{flextable()}}
}
