% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{valign}
\alias{valign}
\title{Set vertical alignment}
\usage{
valign(x, i = NULL, j = NULL, valign = "center", part = "body")
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{columns selection}

\item{valign}{vertical alignment of paragraph within cell,
one of "center" or "top" or "bottom".}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}
}
\description{
change vertical alignment of selected rows and columns of a flextable.
}
\examples{
ft <- flextable(iris[c(1:3, 51:53, 101:103),])
ft <- theme_box(ft)
ft <- merge_v( ft, j = 5)
ft <- valign(ft, j = 5, valign = "top", part = "all")
ft
}
\seealso{
Other sugar functions for table style: 
\code{\link{align}()},
\code{\link{bg}()},
\code{\link{bold}()},
\code{\link{color}()},
\code{\link{empty_blanks}()},
\code{\link{fontsize}()},
\code{\link{font}()},
\code{\link{italic}()},
\code{\link{padding}()},
\code{\link{rotate}()}
}
\concept{sugar functions for table style}
