% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatters.R
\name{colformat_int}
\alias{colformat_int}
\alias{colformat_int.flextable}
\title{format integer columns}
\usage{
colformat_int(x, ...)

\method{colformat_int}{flextable}(x, col_keys, big.mark = ",",
  na_str = "", prefix = "", suffix = "", ...)
}
\arguments{
\item{x}{a flextable object}

\item{...}{additional arguments, unused}

\item{col_keys}{names of the colkeys}

\item{big.mark}{see \code{\link[base]{formatC}}}

\item{na_str}{string to be used for NA values}

\item{prefix}{string to be used as prefix or suffix}

\item{suffix}{string to be used as prefix or suffix}
}
\description{
Format integer columns in a flextable.
}
\examples{
dat <- mtcars

ft <- flextable(dat)
colkeys <- c("vs", "am", "gear", "carb")
ft <- colformat_int(x = ft, col_keys = colkeys, prefix = "# ")
autofit(ft)
}
\seealso{
Other columns formatters: \code{\link{colformat_char}},
  \code{\link{colformat_lgl}}, \code{\link{colformat_num}}
}
\concept{columns formatters}
