% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flexsurvreg.R
\name{AICc.flexsurvreg}
\alias{AICc.flexsurvreg}
\alias{AICC.flexsurvreg}
\title{Second-order Akaike information criterion}
\usage{
\method{AICc}{flexsurvreg}(object, cens = TRUE, ...)

\method{AICC}{flexsurvreg}(object, cens = TRUE, ...)
}
\arguments{
\item{object}{Fitted model returned by \code{\link{flexsurvreg}}
(or \code{\link{flexsurvspline}}).}

\item{cens}{Include censored observations in the sample size term
(\code{n}) used in this calculation. See
\code{\link{BIC.flexsurvreg}} for a discussion of the issues
with defining the sample size.}

\item{...}{Other arguments (currently unused).}
}
\value{
The second-order AIC of the fitted model.
}
\description{
Second-order or "corrected" Akaike information criterion, often
known as AICc (see, e.g. Burnham and Anderson 2002).  This is
defined as -2 log-likelihood + \code{(2*p*n)/(n - p -1)}, whereas
the standard AIC is defined as -2 log-likelihood + \code{2*p},
where \code{p} is the number of parameters and \code{n} is the
sample size.  The correction is intended to adjust AIC for
small-sample bias, hence it only makes a difference to the result
for small \code{n}.
}
\details{
This can be spelt either as \code{AICC} or \code{AICc}.
}
\references{
Burnham, K. P., Anderson, D. R. (2002) Model Selection and Multimodel Inference: a practical information-theoretic approach. Second edition. Springer: New York.
}
\seealso{
\code{\link{BIC}}, \code{\link{AIC}}, \code{\link{BIC.flexsurvreg}}, \code{\link{nobs.flexsurvreg}}
}
