%
%  Copyright (C) 2004-2005 Friedrich Leisch
%  $Id: KLdiv.Rd 3122 2006-11-05 15:10:25Z leisch $
%
\name{KLdiv}
\alias{KLdiv,matrix-method}
\alias{KLdiv,flexmix-method}
\title{Kullback-Leibler Divergence}
\description{
  Estimate the Kullback-Leibler divergence of several distributions.}
\usage{
\S4method{KLdiv}{matrix}(object, eps=1e-4, ...)
}
\arguments{
  \item{object}{see Methods section below}
  \item{eps}{probabilities below this treshold are discarded for
    numerical stability}
  \item{...}{Passed to the matrix method.}
}
\section{Methods}{
  \describe{
    \item{object = "matrix":}{Takes as input a matrix of
      density values with one row per observation and one column per
      distribution.}
    \item{object = "flexmix":}{Returns the Kullback-Leibler divergence
      of the mixture components.}
}}
\details{
  Estimates \deqn{\int f(x) (\log f(x) - \log g(x)) dx}
  for distributions with densities \eqn{f()} and \eqn{g()}.
}
\value{
  A matrix of of KL divergences where the rows correspond to using the
  respective distribution as \eqn{f()} in the formula above.
}
\keyword{methods}
\author{Friedrich Leisch}
\references{
  S. Kullback and R. A. Leibler. On information and sufficiency. The
  Annals of Mathematical Statistics 22(1), pages 79-86, 1951.
  
  Friedrich Leisch. Exploring the structure of mixture model
  components. In Jaromir Antoch, editor, Compstat 2004 - Proceedings in
  Computational Statistics, pages 1405-1412. Physika Verlag, Heidelberg,
  Germany, 2004. ISBN 3-7908-1554-3.
}
\examples{
x = (1:100)/100
## Gaussian and Student t are much closer to each other than
## to the uniform:
KLdiv(cbind(u=dunif(x), n=dnorm(x), t=dt(x, df=10)))
}
