% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatxml.r
\name{fxml_numAttributes}
\alias{fxml_numAttributes}
\title{Attributes of XML elements}
\usage{
fxml_numAttributes(xmlflat.df, elemid)
}
\arguments{
\item{xmlflat.df}{A flat XML dataframe created with \code{\link{fxml_importXMLFlat}}.}

\item{elemid}{The ID of the XML element. The ID is the value of the \code{elemid.} field in the flat XML dataframe.}
}
\value{
The number of attributes of the XML element with ID \code{elemid}.
}
\description{
Determines the number of attributes of an XML element.
}
\examples{
# Load example file with population data from United Nations Statistics Division
# and create flat dataframe
example <- system.file("worldpopulation.xml", package="flatxml")
xml.dataframe <- fxml_importXMLFlat(example)

# Determine the number of attributes of the XML element with ID 4 (xml.dataframe$elemid. ==  4)
fxml_numAttributes(xml.dataframe, 4)

}
\seealso{
\code{\link{fxml_hasAttributes}}, \code{\link{fxml_getAttribute}}, \code{\link{fxml_getAttributesAll}}
}
\author{
Joachim Zuckarelli \email{joachim@zuckarelli.de}
}
