% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_table.R
\name{extract_labels}
\alias{extract_labels}
\alias{extract_labels.pivot_table}
\title{Extract labels}
\usage{
extract_labels(pt, col, labels)

\method{extract_labels}{pivot_table}(pt, col = 1, labels = c())
}
\arguments{
\item{pt}{A \code{pivot_table} object.}

\item{col}{A number, column from which labels are extracted.}

\item{labels}{A vector of strings, set of labels to extract.}
}
\value{
A \code{pivot_table} object.
}
\description{
Extract the given set of labels from a table column in compact format to
generate a new column in the table.
}
\details{
Sometimes a table column includes values of multiple label fields, this is
generally known as compact table format. Given a column number and a set of
labels, it generates a new column with the labels located at the positions
they occupied in the original column and removes them from it.
}
\examples{

pt <- pivot_table(df_ex_compact) |>
  extract_labels(col = 1, labels = c("b1", "b2", "b3", "b4", "Total general"))

}
\seealso{
\code{\link{pivot_table}}

Other pivot table transformation functions: 
\code{\link{fill_labels}()},
\code{\link{fill_values}()},
\code{\link{remove_agg}()},
\code{\link{remove_bottom}()},
\code{\link{remove_cols}()},
\code{\link{remove_empty}()},
\code{\link{remove_k}()},
\code{\link{remove_left}()},
\code{\link{remove_right}()},
\code{\link{remove_rows}()},
\code{\link{remove_top}()},
\code{\link{replace_dec}()},
\code{\link{unpivot}()}
}
\concept{pivot table transformation functions}
