% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatten_table_list.R
\name{flatten_table_list}
\alias{flatten_table_list}
\title{Transform a pivot table list into a flat table}
\usage{
flatten_table_list(lpt = list(), FUN)
}
\arguments{
\item{lpt}{A list of \code{pivot_table} objects.}

\item{FUN}{A function, transformation function that flattens a \code{pivot_table}
object (it returns a \code{tibble}).}
}
\value{
A \code{tibble}, a flat table implemented by a \code{tibble}.
}
\description{
Given a list of pivot tables and a transformation function that flattens a
\code{pivot_table} object, transforms each table using the function and merges the
results into a flat table.
}
\examples{
library(tidyr)

f <- function(pt) {
  pt \%>\%
    set_page(1, 1) \%>\%
    remove_top(1) \%>\%
    define_labels(n_col = 2, n_row = 2) \%>\%
    remove_k() \%>\%
    replace_dec() \%>\%
    fill_values() \%>\%
    fill_labels() \%>\%
    remove_agg() \%>\%
    unpivot()
}

ft <- flatten_table_list(list_pt, f)

}
\seealso{


Other flat table generation functions: 
\code{\link{unpivot}()}
}
\concept{flat table generation functions}
