% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_col_values.R
\name{get_col_values}
\alias{get_col_values}
\title{Get column values}
\usage{
get_col_values(lpt, col = 1, start_row = 2, rows_left = 0)
}
\arguments{
\item{lpt}{List of tables.}

\item{col}{A number, column to consider.}

\item{start_row}{A number, start row in each table.}

\item{rows_left}{A number, rows to ignore at the end of each table.}
}
\value{
Data frame with two columns: Labels in the column, and the index of
the table in the list of tables from which they come.
}
\description{
Gets the values of the indicated column of each table in a list of tables,
avoiding the rows at the beginning or the end of each table that are
indicated.
}
\details{
Sometimes a column includes values of multiple label fields. To facilitate
the study of the labels included in the same column of several tables, this
function gets the values of the indicated column in a list of tables.
}
\examples{
df <- get_col_values(list_pt_compact, start_row = 4)
labels <- sort(unique(df$label))

}
