% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/light_profile2d.R
\name{light_profile2d}
\alias{light_profile2d}
\alias{light_profile2d.default}
\alias{light_profile2d.flashlight}
\alias{light_profile2d.multiflashlight}
\title{2D Partial Dependence and other 2D Profiles}
\usage{
light_profile2d(x, ...)

\method{light_profile2d}{default}(x, ...)

\method{light_profile2d}{flashlight}(
  x,
  v = NULL,
  data = NULL,
  by = x$by,
  type = c("partial dependence", "predicted", "response", "residual", "shap"),
  breaks = NULL,
  n_bins = 11,
  cut_type = "equal",
  use_linkinv = TRUE,
  counts = TRUE,
  counts_weighted = FALSE,
  pd_evaluate_at = NULL,
  pd_grid = NULL,
  pd_indices = NULL,
  pd_n_max = 1000,
  pd_seed = NULL,
  ...
)

\method{light_profile2d}{multiflashlight}(
  x,
  v = NULL,
  data = NULL,
  type = c("partial dependence", "predicted", "response", "residual", "shap"),
  breaks = NULL,
  n_bins = 11,
  cut_type = "equal",
  pd_evaluate_at = NULL,
  pd_grid = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{flashlight} or \code{multiflashlight}.}

\item{...}{Further arguments passed to \code{cut3} resp. \code{formatC} in forming the cut breaks of the \code{v} variables. Not relevant for partial dependence profiles.}

\item{v}{A vector of exactly two variable names to be profiled.}

\item{data}{An optional \code{data.frame}. Not used for \code{type = "shap"}.}

\item{by}{An optional vector of column names used to additionally group the results.}

\item{type}{Type of the profile: Either "partial dependence", "predicted", "response", "residual", or "shap".}

\item{breaks}{Named list of cut breaks specifying how to bin one or more numeric variables. Used to overwrite automatic binning via \code{n_bins} and \code{cut_type}. Ignored for non-numeric \code{v}.}

\item{n_bins}{Approximate number of unique values to evaluate for numeric \code{v}. Can be an unnamed vector of length 2 to distinguish between v.}

\item{cut_type}{Should numeric \code{v} be cut into "equal" or "quantile" bins? Can be an unnamed vector of length 2 to distinguish between v.}

\item{use_linkinv}{Should retransformation function be applied? Default is TRUE. Not used for type "shap".}

\item{counts}{Should observation counts be added?}

\item{counts_weighted}{If \code{counts} is TRUE: Should counts be weighted by the case weights? If TRUE, the sum of \code{w} is returned by group.}

\item{pd_evaluate_at}{An named list of evaluation points for one or more variables. Only relevant for type = "partial dependence".}

\item{pd_grid}{An evaluation \code{data.frame} with exactly two columns, e.g. generated by \code{expand.grid}. Only used for type = "partial dependence". Offers ultimate flexibility.}

\item{pd_indices}{A vector of row numbers to consider in calculating partial dependence profiles. Only used for type = "partial dependence".}

\item{pd_n_max}{Maximum number of ICE profiles to calculate (will be randomly picked from \code{data}). Only used for type = "partial dependence".}

\item{pd_seed}{Integer random seed used to select ICE profiles. Only used for type = "partial dependence".}
}
\value{
An object of class \code{light_profile2d} with the following elements.
\itemize{
\item \code{data} A tibble containing results. Can be used to build fully customized visualizations. Column names can be controlled by \code{options(flashlight.column_name)}.
\item \code{by} Names of group by variables.
\item \code{v} The two variable names evaluated.
\item \code{type} Same as input \code{type}. For information only.
}
}
\description{
Calculates different types of 2D-profiles across two variables. By default, partial dependence profiles are calculated (see Friedman). Other options are response, predicted values, residuals, and shap. The results are aggregated by (weighted) means.
}
\details{
Different binning options are available, see arguments below. For high resolution partial dependence plots, it might be necessary to specify \code{breaks}, \code{pd_evaluate_at} or \code{pd_grid} in order to avoid empty parts in the plot. A high value of \code{n_bins} might not have the desired effect as it internally capped at the number of distinct values of a variable.

For partial dependence and prediction profiles, "model", "predict_function", linkinv" and "data" are required. For response profiles it is "y", "linkinv" and "data" and for shap profiles it is just "shap". "data" can be passed on the fly.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method not implemented yet.

\item \code{flashlight}: 2D profiles for flashlight.

\item \code{multiflashlight}: 2D profiles for multiflashlight.
}}

\examples{
fit <- lm(Sepal.Length ~ ., data = iris)
fl <- flashlight(model = fit, label = "iris", data = iris, y = "Sepal.Length")
light_profile2d(fl, v = c("Petal.Length", "Species"))
}
\references{
Friedman J. H. (2001). Greedy function approximation: A gradient boosting machine. The Annals of Statistics, 29:1189–1232.
}
\seealso{
\code{\link{light_profile}}, \code{\link{plot.light_profile2d}}.
}
