% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolation-class.R
\name{parameters}
\alias{parameters}
\alias{parameters,NelsonSiegel-method}
\alias{parameters,NelsonSiegelSvensson-method}
\title{Get parameters of the interpolation models}
\usage{
parameters(x, ...)
}
\arguments{
\item{x}{a Interpolation object.}

\item{...}{additional arguments. Currently unused.}
}
\value{
A named vector with parameters of the models.
}
\description{
Gets parameters of parametric interpolation models like
\linkS4class{NelsonSiegel} and \linkS4class{NelsonSiegelSvensson}.
}
\examples{
terms <- c(1, 11, 26, 27, 28)
rates <- c(0.0719, 0.056, 0.0674, 0.0687, 0.07)
curve <- spotratecurve(rates, terms, "discrete", "actual/365", "actual")
model <- fit_interpolation(interp_nelsonsiegel(0.1, 0.01, 0.01, 0.01), curve)
parameters(model)
}
