% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sleep.R
\name{sleep_stage_granular}
\alias{sleep_stage_granular}
\title{Granular Sleep Stage Data}
\usage{
sleep_stage_granular(start_date, end_date = start_date)
}
\arguments{
\item{start_date}{The start date of records to be returned in "yyyy-mm-dd" or date(time) format}

\item{end_date}{The end date of records to be returned in "yyyy-mm-dd" or date(time) format}
}
\value{
A tibble of granular sleep stage data. This method is more granular than \link[fitbitr]{sleep_stage_summary}, and returns blocks of time that you spent in each zone throughout the night.
}
\description{
Returns a tibble of nightly sleep stage data.
Very granular. Returns blocks of time spent in each phase.
}
\examples{
\dontrun{
start_date <- lubridate::today() - lubridate::weeks(1)
end_date <- lubridate::today()

sleep_stage_granular(start_date, end_date)
}
}
