% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gbeta1.R
\name{pGBeta1}
\alias{pGBeta1}
\title{Generalized Beta Type-1 Distribution}
\usage{
pGBeta1(p,a,b,c)
}
\arguments{
\item{p}{vector of probabilities.}

\item{a}{single value for shape parameter alpha representing as a.}

\item{b}{single value for shape parameter beta representing as b.}

\item{c}{single value for shape parameter gamma representing as c.}
}
\value{
The output \code{pGBeta1} gives the cumulative density values in vector form.
}
\description{
These functions provide the ability for generating probability density values,
cumulative probability density values and moment about zero values for the
Generalized Beta Type-1 Distribution bounded between [0,1].
}
\details{
The probability density function and cumulative density function of a unit bounded
Generalized Beta Type-1 Distribution with random variable P are given by

\deqn{g_{P}(p)= \frac{c}{B(a,b)} p^{ac-1} (1-p^c)^{b-1} };      \eqn{0 \le p \le 1}
\deqn{G_{P}(p)= \frac{p^{ac}}{aB(a,b)}  2F1(a,1-b;p^c;a+1) }    \eqn{0 \le p \le 1}
\deqn{a,b,c > 0}

The mean and the variance are denoted by
\deqn{E[P]= \frac{B(a+b,\frac{1}{c})}{B(a,\frac{1}{c})} }
\deqn{var[P]= \frac{B(a+b,\frac{2}{c})}{B(a,\frac{2}{c})}-(\frac{B(a+b,\frac{1}{c})}{B(a,\frac{1}{c})})^2 }

The moments about zero is denoted as
\deqn{E[P^r]= \frac{B(a+b,\frac{r}{c})}{B(a,\frac{r}{c})} }
\eqn{r = 1,2,3,....}

Defined as \eqn{B(a,b)} is Beta function.
Defined as \eqn{2F1(a,b;c;d)} is Gaussian Hypergeometric function.

\strong{NOTE} : If input parameters are not in given domain conditions
necessary error messages will be provided to go further.
}
\examples{
#plotting the random variables and probability values
col <- rainbow(5)
a <- c(.1,.2,.3,1.5,2.15)
plot(0,0,main="Probability density graph",xlab="Random variable",ylab="Probability density values",
xlim = c(0,1),ylim = c(0,10))
for (i in 1:5)
{
lines(seq(0,1,by=0.001),dGBeta1(seq(0,1,by=0.001),a[i],1,2*a[i])$pdf,col = col[i])
}

dGBeta1(seq(0,1,by=0.01),2,3,1)$pdf    #extracting the pdf values
dGBeta1(seq(0,1,by=0.01),2,3,1)$mean   #extracting the mean
dGBeta1(seq(0,1,by=0.01),2,3,1)$var    #extracting the variance

pGBeta1(0.04,2,3,4)        #acquiring the cdf values for a=2,b=3,c=4
mazGBeta1(1.4,3,2,2)              #acquiring the moment about zero values
mazGBeta1(2,3,2,2)-mazGBeta1(1,3,2,2)^2        #acquiring the variance for a=3,b=2,c=2

#only the integer value of moments is taken here because moments cannot be decimal
mazGBeta1(3.2,3,2,2)

}
\references{
\insertRef{manoj2013mcdonald}{fitODBOD}
\insertRef{janiffer2014estimating}{fitODBOD}
\insertRef{roozegar2017mcdonald}{fitODBOD}
}
