% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gamma.R
\name{EstMLEGrassiaIIBin}
\alias{EstMLEGrassiaIIBin}
\title{Estimating the shape parameters a and b for Grassia II Binomial distribution}
\usage{
EstMLEGrassiaIIBin(x,freq,a,b)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{freq}{vector of frequencies.}

\item{a}{single value for shape parameter a.}

\item{b}{single value for shape parameter b.}
}
\value{
\code{EstMLEGrassiaIIBin} here is used as a input parameter for the \code{mle2} function of \pkg{bbmle}
package.
}
\description{
The function will estimate the shape parameters using the maximum log likelihood method
for the Grassia II Binomial distribution when the binomial random variables and corresponding frequencies
are given.
}
\details{
\deqn{0 < a,b}
\deqn{x = 0,1,2,...}
\deqn{freq \ge 0}

\strong{NOTE} : If input parameters are not in given domain conditions necessary
error messages will be provided to go further.
}
\examples{
No.D.D=0:7                   #assigning the random variables
Obs.fre.1=c(47,54,43,40,40,41,39,95)  #assigning the corresponding frequencies

#estimating the parameters using maximum log likelihood value and assigning it
parameters=suppressWarnings(bbmle::mle2(EstMLEGrassiaIIBin,start = list(a=0.1,b=0.1),
data = list(x=No.D.D,freq=Obs.fre.1)))

bbmle::coef(parameters)         #extracting the parameters
}
\references{
Grassia, A., 1977. On a family of distributions with argument between 0 and 1
obtained by transformation of the gamma and derived compound distributions.
Australian Journal of Statistics, 19(2), pp.108-114.
}
