% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_data_exploration.R
\name{fst_get_top_ngrams}
\alias{fst_get_top_ngrams}
\title{Make Top N-grams Table}
\usage{
fst_get_top_ngrams(
  data,
  number = 10,
  ngrams = 1,
  norm = "number_words",
  pos_filter = NULL,
  strict = TRUE
)
}
\arguments{
\item{data}{A dataframe of text in CoNLL-U format.}

\item{number}{The number of n-grams to return, default is `10`.}

\item{ngrams}{The type of n-grams to return, default is `1`.}

\item{norm}{The method for normalising the data. Valid settings are
`"number_words"` (the number of words in the responses, default),
`"number_resp"` (the number of responses), or `NULL` (raw count returned).}

\item{pos_filter}{List of UPOS tags for inclusion, default is `NULL` which
means all word types included.}

\item{strict}{Whether to strictly cut-off at `number` (ties are
alphabetically ordered), default is `TRUE`.}
}
\value{
A table of the most frequently occurring n-grams in the data.
}
\description{
Creates a table of the most frequently-occurring n-grams within the
data.
}
\examples{
q11_1 <- conllu_dev_q11_1_nltk
fst_get_top_ngrams(q11_1, norm = NULL)
fst_get_top_ngrams(q11_1, number = 10, ngrams = 1, norm = "number_resp")
cb <- conllu_cb_bullying
pf <- c("NOUN", "VERB", "ADJ", "ADV")
fst_get_top_ngrams(cb, number = 15, pos_filter = pf)
}
