% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{kinetic_energy_nordic_power_system_RTD}
\alias{kinetic_energy_nordic_power_system_RTD}
\title{Kinetic energy of the Nordic power system - real time data}
\usage{
kinetic_energy_nordic_power_system_RTD(
  start_time = NA,
  end_time = NA,
  user_key = NA
)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains real-time estimate of the kinetic
energy of the Nordic power system calculated by the Nordic transmission
system operators. The data is updated every 1 minute. Historical data
as of 2015/3/27 available.
}
\description{
Check https://data.fingrid.fi/en/dataset/kinetic-energy-nordic-realtime
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- kinetic_energy_nordic_power_system_RTD(
    start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
