% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{cogeneration_district_heating_RTD}
\alias{cogeneration_district_heating_RTD}
\title{Cogeneration of district heating - real time data}
\usage{
cogeneration_district_heating_RTD(
  start_time = NA,
  end_time = NA,
  user_key = NA
)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains cogeneration of district heating
based on the real-time measurements in Fingrid's operation control
system. The data is updated every 3 minutes. Cogeneration means power
plants that produce both electricity and district heating or process
steam (combined heat and power, CHP).
}
\description{
Check https://data.fingrid.fi/en/dataset/cogeneration
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- cogeneration_district_heating_RTD(
    start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
