% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quick_charts.R
\name{population}
\alias{population}
\title{Plot population pyramid}
\usage{
population(data, value, sex, age, area, area_name, comparator_1,
  comparator_2, title, subtitle, xlab)
}
\arguments{
\item{data}{data.frame object to plot using ggplot2 functions}

\item{value}{field containing variable to be plotted on x axis (unquoted)}

\item{sex}{field containing sex variable (unquoted)}

\item{age}{field containing age variable (unquoted)}

\item{area}{field containing variable to be plotted on y axis (unquoted)}

\item{area_name}{string; name of the local area (this should exist in the
field described by the area parameter)}

\item{comparator_1}{string; name of comparator area (this should exist in the
field described by the area parameter)}

\item{comparator_2}{string; name of comparator area (this should exist in the
field described by the area parameter)}

\item{title}{string; title of chart}

\item{subtitle}{string; text to use as subtitle to graph}

\item{xlab}{string; x-axis title}
}
\value{
a ggplot of a population pyramid against 2 optional comparators
}
\description{
Plot population pyramid
}
\examples{
\donttest{
# This example is untested because of the time required to retrieve the data
library(fingertipsR)
library(dplyr)
agelevels <- c("0-4", "5-9","10-14","15-19",
               "20-24","25-29","30-34",
               "35-39","40-44","45-49",
               "50-54","55-59","60-64",
               "65-69","70-74","75-79",
               "80-84","85-89","90+")
pops <- fingertips_data(92708) \%>\%
        filter(Timeperiod == "2015" &
                       Sex \%in\% c("Male", "Female") &
                       Age != "All ages") \%>\%
        mutate(Age = gsub(" yrs","", Age),
               Age = factor(Age,
                            levels = agelevels)) \%>\%
        droplevels()
p <- population(pops,
                value = Value,
                sex = Sex,
                age = Age,
                area = AreaName,
                area_name = "Nottingham",
                comparator_1 = "England",
                comparator_2 = "East Midlands region",
                title = "Age Profile",
                subtitle = paste(unique(pops$IndicatorName), unique(pops$Timeperiod)),
                xlab = "\% of total population")
p}
}
\seealso{
Other quick charts: \code{\link{box_plots}},
  \code{\link{compare_areas}},
  \code{\link{compare_indicators}}, \code{\link{map}},
  \code{\link{overview}}, \code{\link{trends}}
}
\concept{quick charts}
