% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spine_chart_utils.R
\name{create_datatable}
\alias{create_datatable}
\title{Data table supporting information}
\usage{
create_datatable(
  data,
  indicator,
  area_code,
  timeperiod,
  trend,
  count,
  value,
  local_area_code,
  median_line_area_code,
  comparator_area_code,
  dps = 1,
  header_width,
  horizontal_arrow_multiplier
)
}
\arguments{
\item{data}{a data frame to create the spine chart from. the data frame
should contain data for all area types included in the chart (eg, if
plotting for County & UA with a comparator of region and a median line for
national, the data frame should contain all of these data)}

\item{indicator}{unquoted field name of the field containing the indicator
labels. Take care as errors will occur where indicator labels are the same
but data exist for multiple sub-categories (for example, sex or age)}

\item{area_code}{unquoted field name where area codes are stored
(local_area_code, median_line_area_code and comparator_area_code, if using,
should all exist in this field)}

\item{timeperiod}{unquoted field name of the time period field}

\item{trend}{unquoted field name of the trend field; if the user doesn't want
to display trend information then leave this incomplete and amend the
header_labels argument to remove the Trend header. Text within this field
should contain one of the following words to control the arrows that are
displayed; "decreasing", "increasing", "no significant change", "could not
be calculated". The text within this field should contain one of the
following words to control the colour; "better", "worse", "no significant
change". If none of these words appear in the string, the words
"increasing" or "decreasing" will be used to colour the arrows in different
shades of blue"}

\item{count}{unquoted field name where the count (numerator) is stored}

\item{value}{unquoted field name containing the values to be plotted}

\item{local_area_code}{string; the code of the area that the spine chart is
being drawn for}

\item{median_line_area_code}{string; area code for the median line. Defaults
to "E92000001" (England)}

\item{comparator_area_code}{string; area code for the comparator point.
Defaults to NA}

\item{dps}{number of decimal places to use in the data table}

\item{header_width}{x dimension of chart to be used for normalising the arrow
length when horizonal}

\item{horizontal_arrow_multiplier}{number to scale horizontal trend arrows. A
value below 1 will shorten the arrows}
}
\value{
A data frame containing the information that sits alongside the spine
  chart
}
\description{
Returns a data frame containing the data that sits next to the spine chart
}
