% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicator_metadata.R
\name{indicator_metadata}
\alias{indicator_metadata}
\title{Indicator metadata}
\usage{
indicator_metadata(IndicatorID = NULL, DomainID = NULL, ProfileID = NULL)
}
\arguments{
\item{IndicatorID}{Numeric vector, id of the indicator of interest}

\item{DomainID}{Numeric vector, id of domains of interest}

\item{ProfileID}{Numeric vector, id of profiles of interest}
}
\value{
The metadata associated with each indicator/domain/profile identified
}
\description{
Outputs a data frame containing the metadata for selected indicators
}
\examples{
\dontrun{
# Returns metadata for indicator ID 90362 and 1107
indicatorIDs <- c(90362, 1107)
indicator_metadata(indicatorIDs)

# Returns metadata for the indicators within the domain 1000101
indicator_metadata(DomainID = 1000101)

# Returns metadata for the indicators within the profile with the ID 129
indicator_metadata(ProfileID = 129)}
}
\seealso{
\code{\link{indicators}} for indicator lookups,
  \code{\link{profiles}} for profile lookups,
  \code{\link{deprivation_decile}} for deprivation lookups and
  \code{\link{area_types}} for area types and their parent mappings

Other lookup functions: \code{\link{area_types}},
  \code{\link{deprivation_decile}},
  \code{\link{indicators}}, \code{\link{profiles}}
}
