% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finbif_collections.R
\name{finbif_collections}
\alias{finbif_collections}
\alias{fb_collections}
\title{FinBIF collections}
\usage{
finbif_collections(
  filter,
  select,
  subcollections = TRUE,
  supercollections = FALSE,
  locale = getOption("finbif_locale"),
  nmin = 0,
  cache = getOption("finbif_use_cache")
)
}
\arguments{
\item{filter}{Logical. Expression indicating elements or rows to keep:
missing values are taken as false.}

\item{select}{Expression. Indicates columns to select from the data frame.}

\item{subcollections}{Logical. Return subcollection metadata of higher level
collections.}

\item{supercollections}{Logical. Return lowest level collection metadata.}

\item{locale}{Character. Language of data returned. One of "en", "fi", or
"sv".}

\item{nmin}{Integer. Filter collections by number of records. Only return
information on collections with greater than value specified. If \code{NA} then
return information on all collections.}

\item{cache}{Logical. Use cached data.}
}
\value{
A data.frame.
}
\description{
Get information on collections in the FinBIF database.
}
\examples{
\dontrun{

# Get collection metadata
collections <- finbif_collections()
}
}
