% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_mcar.R
\name{ff_mcar}
\alias{ff_mcar}
\alias{finalfit_mcar}
\title{Missing completely at random}
\usage{
ff_mcar(.data, dependent, explanatory, na_include = FALSE)

finalfit_mcar(.data, dependent, explanatory, na_include = FALSE)
}
\arguments{
\item{.data}{Dataframe.}

\item{dependent}{Variable to test missingness against other variables with.}

\item{explanatory}{Variables to have missingness tested against.}

\item{na_include}{Include missing data in explanatory variables as a factor
level.}
}
\value{
A dataframe comparing missing data in the dependent variable across
  explanatory variables.
}
\description{
Missing completely at random
}
\examples{
library(finalfit)

explanatory = c("age", "age.factor", "extent.factor", "perfor.factor")
dependent = "mort_5yr"

colon_s \%>\%
  ff_glimpse(dependent, explanatory)

colon_s \%>\%
 ff_missing(dependent, explanatory)

colon_s \%>\%
  ff_mcar(dependent, explanatory)
}
