% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_rcvr_type.R
\name{get_receiver_type}
\alias{get_receiver_type}
\title{Get Receiver Type}
\usage{
get_receiver_type(file_list)
}
\arguments{
\item{file_list}{A vector of raw acoustic detection file paths}
}
\value{
A dataframe containing the file path, file name, and technology type
}
\description{
This function takes a list of file paths to raw acoustic receiver detection
files supplied by the user and identifies the type of acoustic receiver
technology (Lotek, ATS, Teknologic) used to generate the file.
}
\examples{
# get a list of files
files <- system.file("extdata", package = "filteRjsats")|> list.files()

# get the receiver type
get_receiver_type(files)
}
