% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_pattern.r
\name{fill_pattern}
\alias{fill_pattern}
\alias{fillPatternGrob}
\title{Patterned Fills for Grobs}
\usage{
fill_pattern(
  patterns = "brick",
  fg = "black",
  bg = "transparent",
  angle = 0,
  width = 5,
  height = NA,
  lwd = 1,
  lty = "solid",
  fun = NULL
)

fillPatternGrob(
  pattern = "brick",
  fg = "black",
  bg = "transparent",
  angle = 0,
  width = 5,
  height = NA,
  lwd = 1,
  lty = "solid",
  fun = NULL
)
}
\arguments{
\item{patterns, pattern}{The pattern specification. Options are \code{"brick"},
\code{"chevron"}, \code{"fish"}, \code{"grid"}, \code{"herringbone"}, \code{"hexagon"},
\code{"octagon"}, \code{"rain"}, \code{"saw"}, \code{"shingle"}, \code{"rshingle"},
\code{"stripe"}, and \code{"wave"}, optionally abbreviated and/or suffixed with
modifiers. See "Pattern Names" section below. Default: \code{"brick"}}

\item{fg}{Foreground color, for the pattern's lines. Default: \code{"black"}}

\item{bg}{Background color (or grob). Default: \code{"transparent"}}

\item{angle}{How much the rotate the pattern, given in degrees clockwise.
Default: \code{0}}

\item{width}{The width of the pattern tile. Assumed to be millimeters
unless set otherwise with \code{\link[=unit]{unit()}}. Default: \code{5}}

\item{height}{The height of the pattern tile, or \code{NA} to match \code{width}.
Assumed to be millimeters unless set otherwise with \code{\link[=unit]{unit()}}.
Default: \code{NA}}

\item{lwd}{Line width. A positive number.
See \code{\link[graphics:par]{graphics::par()}} for additional details. Default: \code{1}}

\item{lty}{Line type. One of \code{"solid"}, \code{"dashed"}, \code{"dotted"},
\code{"dotdash"}, \code{"longdash"}, or \code{"twodash"}.
See \code{\link[graphics:par]{graphics::par()}} for additional details. Default: \code{"solid"}}

\item{fun}{A function for modifying graphical parameters immediately
before rendering. Should accept two parameters: \code{env}, an
environment that the function should modify, and \code{row}, the row of
transformed data that ggbuild has constructed for this grob
(including aes mappings). The return value is not used.
Default: \code{NULL}}
}
\value{
\code{fill_pattern()} returns a list of \code{grid::pattern()} objects;
\code{fillPatternGrob()} returns a \code{grid::gTree()} object.
}
\description{
Patterned Fills for Grobs
}
\details{
\code{fillPatternGrob()} expects a single value for each parameter.
\code{fill_pattern()} can accept a vector of values for each parameter
which are subset or recycled as needed to obtain the same number as
\code{length(patterns)}.
}
\section{Pattern Names}{


\strong{Base name:}
\itemize{
\item Pattern names must always begin with one of \code{"brick"}, \code{"chevron"},
\code{"fish"}, \code{"grid"}, \code{"herringbone"}, \code{"hexagon"}, \code{"octagon"}, \code{"rain"},
\code{"saw"}, \code{"shingle"}, \code{"rshingle"}, \code{"stripe"}, or \code{"wave"}.
\item These names support partial matching, e.g. \code{"her"}, \code{"herring"}, and
\code{"herringbone"} are all valid. However, tiling designs may be added in
the future, so it is recommended to use the full names in finished code.
}

\strong{Angle modifier:}
\itemize{
\item A number immediately following the tiling design, such as \code{"stripe45"},
\code{"fish180"}, or \code{"saw20"}.
\item Is added to the \code{angle} argument; \code{fill_pattern("brick45", angle=45)} is
equivalent to \code{fill_pattern("brick90")}.
}

\strong{Width and height modifier:}
\itemize{
\item An underscore followed by a single size to be used for both width and height.
\item Or, an underscore followed by the new width and height separated by a colon.
\item Can be absolute sizes (\code{"grid_4"} or \code{"hex_5mm:0.1npc"}) or relative to
the \code{width} and \code{height} arguments (\code{"saw_sm"} or \code{"brick_*2:/2"}). The
shorthand values \code{"xs"}, \code{"sm"}, \code{"md"}, \code{"lg"}, and \code{"xl"} are equivalent
to \code{"/4"}, \code{"/2"}, \code{"1"}, \code{"*2"}, and \code{"*4"}, respectively.
}

\strong{Line width and style:}
\itemize{
\item An underscore, followed by a number, followed by one of \code{"solid"},
\code{"dashed"}, \code{"dotted"}, \code{"dotdash"}, \code{"longdash"}, or \code{"twodash"}. For
example, \code{"shingle_0.5dashed"} or \code{"wave_2solid"}.
\item The number component is optional, so \code{"oct_longdash"} is also valid, and
will use \code{lwd} for the line width.
\item To specify just the line width, suffix the number with "lwd":
\code{"grid_2lwd"} will use \code{lty} for the line style.
}

\strong{Combinations:}
\itemize{
\item Modifiers can be combined in any order. For example, \code{"hex_lg:xl_2dotted"}
or \code{"grid45_dashed_1.4lwd_:6mm_sm:"}.
}
}

\examples{
    library(grid)
    library(fillpattern)
    
    grid.newpage()
    grid.rect(gp = gpar(fill = fill_pattern("brick", bg = "gray", angle = 90)))
    
    grid.newpage()
    gp <- Map(gpar, fill = fill_pattern(
      patterns = c("grid_3lwd", "stripe_longdash", "herringbone45", "hexagon_lg"),
      fg       = c("black",     "white",           "black",         "blue"),
      bg       = c("white",     "black",           "cyan",          "beige") ))
    grid.circle( gp = gp[[1]], x = 1/4, y = 3/4, r = 1/5)
    grid.polygon(gp = gp[[2]], x = c(9,12,15)/16, y = c(15,9,15)/16)
    grid.rect(   gp = gp[[3]], x = 1/4, y = 1/4, width = 2/5, height = 2/5)
    grid.rect(   gp = gp[[4]], x = 3/4, y = 1/4, width = 2/5, height = 2/5)
}
\seealso{
\code{\link[=scale_fill_pattern]{scale_fill_pattern()}} for \code{ggplot2} integration.
}
