% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str-put-in-pos.R
\name{put_in_pos}
\alias{put_in_pos}
\title{Put specified strings in specified positions in an otherwise empty character
vector.}
\usage{
put_in_pos(strings, positions)
}
\arguments{
\item{strings}{A character vector of the strings to put in positions
(coerced by \link{as.character} if not character already).}

\item{positions}{The indices of the character vector to be occupied by the
elements of strings. Must be the same length as strings or of length 1.}
}
\value{
A character vector.
}
\description{
Create a character vector with a set of strings at specified positions in
that character vector, with the rest of it taken up by empty strings.
}
\examples{
put_in_pos(1:3, c(1, 8, 9))
put_in_pos(c("Apple", "Orange", "County"), c(5, 7, 8))
put_in_pos(1:2, 5)
}
