% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings.R
\name{str_after_nth}
\alias{str_after_nth}
\alias{str_before_nth}
\title{Text before or after \eqn{n}th occurrence of pattern.}
\usage{
str_after_nth(strings, pattern, n = 1)

str_before_nth(strings, pattern, n = 1)
}
\arguments{
\item{strings}{A character vector.}

\item{pattern}{A regular expression.}

\item{n}{A natural number to identify the \eqn{n}th occurrence (defaults to
first (\code{n = 1})). This can be negatively indexed, so if you wish to select
the \emph{last} occurrence, you need \code{n = -1}, for the second-last, you
need \code{n = -2} and so on.}
}
\value{
A character vector of the desired strings.
}
\description{
Extract the part of a string which is before or after the \eqn{n}th
occurrence of a specified pattern, vectorised over the string. One can also
choose \eqn{n} to be the \emph{last} occurrence of the pattern. See argument
\code{n}.
}
\examples{
string <- "ab..cd..de..fg..h"
str_after_nth(string, "\\\\.\\\\.", 3)
str_before_nth(string, "e", 1)
str_before_nth(string, "\\\\.", -3)
str_before_nth(string, ".", -3)
str_before_nth(rep(string, 2), fixed("."), -3)
}
