% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings.R
\name{StringsWithPatterns}
\alias{StringsWithPatterns}
\title{Which strings match the patterns?}
\usage{
StringsWithPatterns(strings, patterns, ignore.case = FALSE, any = FALSE)
}
\arguments{
\item{strings}{A character vector.}

\item{patterns}{Regular expressions.}

\item{ignore.case}{Do we want to ignore case when matching patterns?}

\item{any}{Set this to \code{TRUE} if you want to see which strings match
\emph{any} of the patterns and not \emph{all} (all is the default).}
}
\value{
A character vector of strings matching the patterns.
}
\description{
Given a character vector of strings and one of patterns (in regular
expression), which of the strings match all (or any) of the patterns.
}
\examples{
StringsWithPatterns(c("abc", "bcd", "cde"), c("b", "c"))
StringsWithPatterns(c("abc", "bcd", "cde"), c("b", "c"), any = TRUE)
StringsWithPatterns(toupper(c("abc", "bcd", "cde")), c("b", "c"), any = TRUE)
StringsWithPatterns(toupper(c("abc", "bcd", "cde")), c("b", "c"), any = TRUE,
ignore.case = TRUE)
}
