% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polarCoord.R
\name{rotateGraph}
\alias{rotate.graph}
\alias{rotateGraph}
\alias{rotategraph}
\title{Rotate a graph using polar coordinates}
\usage{
rotateGraph(coords, scale = NULL, origin, axis, fixedPos = 2)
}
\arguments{
\item{coords}{a nx2 dimensional matrix corresponding to the cartesian coordinates of the n datapoints.}

\item{scale}{a nx2 dimensional matrix. This is used when comparing two graphs to one another. This parameter will 
scale one graph to the other by ensuring the average of the radi are the same across the two graphs. Defaults to NULL.}

\item{origin}{an integer indicating which datapoint (i.e., which row) should be fixed as the origin.}

\item{axis}{an integer indicating which datapoint (i.e., which row) should be fixed on the x-axis.}

\item{fixedPos}{an integer indicating which datapoint (i.e., which row) must be positive on y.}
}
\value{
\item{coords}{the new coordinates obtained after rotation}

\item{radi}{a vector of the radi for each of the datapoints}
}
\description{
Rotates the x-y coordinates by choosing one datapoint as the origin, choosing another to be fixed on the x axis, and choosing a third to be positive or negative.
}
\details{
Many algorithms exist for projecting m-dimensional datapoints in two-dimensions (e.g., tsne and MDS). 
However, often they begin the algorithm by randomly placing datapoints in an arbitrary position. Unfortunately, this makes the axes 
meaningless from one iteration of the algorithm to the next, making comparisons across datasets (for example) impossible. One solution 
is to fix one datapoint to the origin, while rotating the others about the origin. This algorithm does just that by using polar coordinates.
}
\author{
Dustin Fife
}
\references{
\url{http://www.mathsisfun.com/polar-cartesian-coordinates.html}
}
\seealso{
\code{\link{compute.theta}}.
}

