\name{densityPlotR}
\alias{densityPlotR}
\title{Generate a density plot using a formula}
\usage{
  densityPlotR(formula, data = NULL, colors = NULL, ...)
}
\arguments{
  \item{formula}{a formula object where the grouping
  variable is on the right side of the ~ and the response
  variable (quantitative) is on the left side of the ~.}

  \item{data}{a dataset containing the variables listed in
  the formula}

  \item{colors}{a vector the same length as the number of
  levels of the grouping variable indicating the colors to
  be used for the density lines}

  \item{...}{other arguments passed to the plot function}
}
\description{
  Given two groups with scores on a quantitative variable,
  \code{densityPlotR} will draw both distributions, one for
  each group.
}
\examples{
densityPlotR(Petal.Width~Species, data=iris)
}
\author{
  Dustin Fife
}
\seealso{
  \code{\link{boxplot}}, \code{\link{prism.plots}},
  \code{\link{plotSigBars}}
}

