% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fidofit_s3.R
\name{orthusfit}
\alias{orthusfit}
\title{Create orthusfit object}
\usage{
orthusfit(
  D,
  N,
  Q,
  P,
  coord_system,
  iter = NULL,
  alr_base = NULL,
  ilr_base = NULL,
  Eta = NULL,
  Lambda = NULL,
  Sigma = NULL,
  Sigma_default = NULL,
  Z = NULL,
  Y = NULL,
  X = NULL,
  upsilon = NULL,
  Theta = NULL,
  Xi = NULL,
  Xi_default = NULL,
  Gamma = NULL,
  init = NULL,
  names_categories = NULL,
  names_samples = NULL,
  names_Zdimensions = NULL,
  names_covariates = NULL
)
}
\arguments{
\item{D}{number of multinomial categories}

\item{N}{number of samples}

\item{Q}{number of covariates}

\item{P}{Dimension of second dataset (e.g., nrows(Z) )}

\item{coord_system}{coordinate system objects are represented in (options 
include "alr", "clr", "ilr", and "proportions")}

\item{iter}{number of posterior samples}

\item{alr_base}{integer category used as reference 
(required if coord_system=="alr")}

\item{ilr_base}{(D x D-1) contrast matrix (required if coord_system=="ilr")}

\item{Eta}{Array of samples of Eta}

\item{Lambda}{Array of samples of Lambda}

\item{Sigma}{Array of samples of Sigma (null if coord_system=="proportions")}

\item{Sigma_default}{Array of samples of Sigma in alr base D, used if 
coord_system=="proportions"}

\item{Z}{PxN matrix of real valued observations}

\item{Y}{DxN matrix of observed counts}

\item{X}{QxN design matrix}

\item{upsilon}{scalar prior dof of inverse wishart prior}

\item{Theta}{prior mean of Lambda}

\item{Xi}{Matrix of prior covariance for inverse wishart 
(null if coord_system=="proportions")}

\item{Xi_default}{Matrix of prior covariance for inverse wishart in alr 
base D (used if coord_system=="proportions")}

\item{Gamma}{QxQ covariance matrix prior for Lambda}

\item{init}{matrix initial guess for Lambda used for optimization}

\item{names_categories}{character vector}

\item{names_samples}{character vector}

\item{names_Zdimensions}{character vector}

\item{names_covariates}{character vector}
}
\value{
object of class orthusfit
}
\description{
Create orthusfit object
}
\seealso{
\code{\link{pibble}}
}
