% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_basset.R
\name{basset_fit}
\alias{basset_fit}
\alias{basset}
\alias{refit.bassetfit}
\title{Interface to fit basset models}
\usage{
basset(
  Y = NULL,
  X,
  upsilon = NULL,
  Theta = NULL,
  Gamma = NULL,
  Xi = NULL,
  init = NULL,
  pars = c("Eta", "Lambda", "Sigma"),
  ...
)

\method{refit}{bassetfit}(m, pars = c("Eta", "Lambda", "Sigma"), ...)
}
\arguments{
\item{Y}{D x N matrix of counts (if NULL uses priors only)}

\item{X}{Q x N matrix of covariates (cannot be NULL)}

\item{upsilon}{dof for inverse wishart prior (numeric must be > D)
(default: D+3)}

\item{Theta}{A function from dimensions dim(X) -> (D-1)xN (prior mean of gaussian process)}

\item{Gamma}{A function from dimension dim(X) -> NxN (kernel matrix of gaussian process)}

\item{Xi}{(D-1)x(D-1) prior covariance matrix
(default: ALR transform of diag(1)*(upsilon-D)/2 - this is
essentially iid on "base scale" using Aitchison terminology)}

\item{init}{(D-1) x Q initialization for Eta for optimization}

\item{pars}{character vector of posterior parameters to return}

\item{...}{other arguments passed to \link{pibble} (which is used internally to
fit the basset model)}

\item{m}{object of class bassetfit}
}
\value{
an object of class bassetfit
}
\description{
Basset (A Lazy Learner) - non-linear regression models in fido
}
\details{
the full model is given by:
\deqn{Y_j \sim Multinomial(Pi_j)}
\deqn{Pi_j = Phi^{-1}(Eta_j)}
\deqn{Eta \sim MN_{D-1 x N}(Lambda, Sigma, I_N)}
\deqn{Lambda \sim GP_{D-1 x Q}(Theta(X), Sigma, Gamma(X))}
\deqn{Sigma \sim InvWish(upsilon, Xi)}
Where Gamma(X) is short hand for the Gram matrix of the Kernel function.

Default behavior is to use MAP estimate for uncollaping the LTP
model if laplace approximation is not preformed.
}
