% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{conjugateLinearModel}
\alias{conjugateLinearModel}
\title{Solve Bayesian Multivariate Conjugate Linear Model}
\usage{
conjugateLinearModel(Y, X, Theta, Gamma, Xi, upsilon, n_samples = 2000L)
}
\arguments{
\item{Y}{matrix of dimension D x N}

\item{X}{matrix of covariates of dimension Q x N}

\item{Theta}{matrix of prior mean of dimension D x Q}

\item{Gamma}{covariance matrix of dimension Q x Q}

\item{Xi}{covariance matrix of dimension D x D}

\item{upsilon}{scalar (must be > D-1) degrees of freedom for InvWishart prior}

\item{n_samples}{number of samples to draw (default: 2000)}
}
\value{
List with components
\enumerate{
\item Lambda Array of dimension (D-1) x Q x n_samples (posterior samples)
\item Sigma Array of dimension (D-1) x (D-1) x n_samples (posterior samples)
}
}
\description{
See details for model.  Notation: \code{N} is number of samples,
\code{D} is the dimension of the response, \code{Q} is number
of covariates.
}
\details{
\deqn{Y ~ MN_{D-1 x N}(Lambda*X, Sigma, I_N)}
\deqn{Lambda ~ MN_{D-1 x Q}(Theta, Sigma, Gamma)}
\deqn{Sigma ~ InvWish(upsilon, Xi)}
This function provides a means of sampling from the posterior distribution of
\code{Lambda} and \code{Sigma}.
}
\examples{
sim <- pibble_sim()
eta.hat <- t(alr(t(sim$Y+0.65)))
fit <- conjugateLinearModel(eta.hat, sim$X, sim$Theta, sim$Gamma, 
                            sim$Xi, sim$upsilon, n_samples=2000)
}
