% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fic.R
\name{fic.default}
\alias{fic.default}
\alias{FIC}
\alias{fic}
\title{Focused information criteria: main user interface}
\usage{
\method{fic}{default}(wide, inds, inds0 = NULL, gamma0 = 0, focus = NULL,
  focus_deriv = NULL, wt = NULL, sub = NULL, fns = NULL, FIC = FALSE,
  B = 0, loss = loss_mse, tidy = TRUE, ...)

fic(wide, ...)
}
\arguments{
\item{wide}{Fitted model object containing the wide model.}

\item{inds}{Matrix or vector of indicators for which parameters are included in the submodel or submodels to be assessed.

A matrix should be supplied if there are multiple submodels.  This should have number of rows equal to the number of submodels, and number of columns equal to the total number of parameters in the wide model.  It contains 1s in the positions where the parameter is included in the submodel, and 0s in positions where the parameter is excluded.  This should always be 1 in the positions defining the narrow model, as specified in \code{inds0}.}

\item{inds0}{Vector of indicators specifying the narrow model, in the same format as \code{inds}.  If this is omitted, the narrow model is assumed to be defined by the first row of \code{inds} (if \code{inds} is a matrix), or \code{inds} itself if this is a vector.}

\item{gamma0}{Vector of special values taken by the parameters \eqn{gamma} which define the narrow model.

This defaults to 0, as in covariate selection, where "excluded" coefficients are fixed to 0. 

This should either be a scalar, assumed to be the same for all parameters fixed in the narrow model, or a vector of length equal to the number of parameters from the wide model which are fixed in the narrow model, that is, the number of entries of \code{inds0} which are zero.}

\item{focus}{An R function with:

\itemize{
\item first argument named \code{par}, denoting a vector of parameters, of the same length as in wide model

\item other arguments defining alternative focuses.  These are supplied through the \code{...} argument to \code{\link{fic}}.  In the built-in examples, there is an argument named \code{X}, denoting alternative covariate values.  The required format is documented below. 
}

The function should return the focus quantity of interest.  If additional arguments are supplied which are vectors or matrices, e.g. \code{X}, then these are assumed to represent multiple focuses, and \code{focus} should return a vector giving the focus for \code{par} and each row of \code{X}.  Otherwise \code{focus} should return a scalar giving the focus value at \code{par}.

Not required if \code{focus_deriv} is specified.

Alternatively, \code{focus} can be a character string naming a built-in focus function supplied by the \pkg{fic} package.  Currently these include:

\code{"prob_logistic"}, the probability of the outcome in a logistic regression model

\code{"mean_normal"} the mean outcome in a normal linear regression model

See \code{\link{focus_fns}} for the functions underlying these built-in focuses.}

\item{focus_deriv}{Vector of partial derivatives of the focus function with respect to the parameters in the wide model.  This is not usually needed, as it can generally be computed automatically and accurately from the function supplied in \code{focus}, using numerical differentiation.}

\item{wt}{Vector of weights to apply to different covariate values in \code{X}.  This should have length equal to the number of alternative values for the covariates, that is, the number of alternative focuses of interest.  The covariate-specific focused model comparison statistics are then supplemented by averaged statistics for a population defined by this distribution of covariate values.  If this argument is omitted, the values are assumed to have equal weight when computing the average.   The weights are not normalised, though the interpretation is unclear if the weights don't sum to one.}

\item{sub}{List of fitted model objects corresponding to each submodel to be assessed. 

For some classes of models with built in methods for \code{fic}, e.g. \code{\link{fic.glm}}, the submodels are fitted automatically by default, so this argument does not need to be supplied.

Otherwise, this argument can be omitted, but it is required if you want the estimate of the focus function under each submodel to be included in the results, which is usually the case.}

\item{fns}{Named list of functions to extract the quantities from the fitted model object that are required to calculate the focused model comparison statistics.  By default this is

\code{list(coef=coef, nobs=nobs, vcov=vcov)}

Suppose the fitted model object is called \code{mod}.  This default list assumes that

\itemize{
\item \code{coef(mod)} returns the vector of parameter estimates,

\item \code{vcov(mod)} returns the covariance matrix for the parameter estimates,
\item \code{nobs(mod)} returns the number of observations used in the model fit.  Only required if the `classic` FIC is required, and not required to compute the mean square error of the focus.
}

If one or more of these functions does not work for \code{mod}, then the defaults can be changed.
For example, suppose the functions \code{coef()}, \code{nobs()} and \code{vcov()} are
not understood (or return something different) for your class of model objects, but
the parameters are stored in \code{mod$estimates},
the number of observations is in \code{mod$data$nobs}, and
the covariance matrix is in \code{mod$cov}, 
then the \code{fns} argument should be set to 

\code{list(
     coef = function(x){x$estimates},
     nobs = function(x){x$data$nobs},
     vcov = function(x){x$cov}
     )}

If less than three components are specified in \code{fns}, then the missing components are assumed to take their default values.}

\item{FIC}{If \code{TRUE}, then the Focused Information Criterion is returned with the results alongside the mean squared error and its components.  This is done for built-in model classes, but optional for user-defined model classes, since it requires knowledge of the sample size \code{n} as well as the estimates and covariance matrix under the wide model.}

\item{B}{If \code{B} is 0 (the default) the standard analytic formulae for the focused model comparison statistics are used with mean square error loss.   If \code{B}>0, then a parametric bootstrap method is used with \code{B} bootstrap samples, and the loss specified in the \code{loss} argument. More details of this approach are given in the package vignette "Focused model comparison with bootstrapping and alternative loss functions".}

\item{loss}{A function returning an estimated loss for a submodel estimate under the sampling distribution of the wide model.  Only applicable when using bootstrapping.  This should have two arguments \code{sub} and \code{wide}.  \code{sub} should be a scalar giving the focus estimate from a submodel.  \code{wide} should be a vector with a sample of focus estimates from the wide model, e.g. generated by a bootstrap method.  By default this is a function calculating the root mean square error of the submodel estimate.   An example is given in the vignette  "Focused model comparison with bootstrapping and alternative loss functions".}

\item{tidy}{If \code{TRUE} the results are returned as a data frame with variables to indicate the submodels, focuses and corresponding result statistics.  If \code{FALSE}, the results are returned as a three-dimensional array, with dimensions indexed by the submodels, result statistics and focuses respectively.}

\item{\dots}{Other arguments to the focus function can be supplied here.

The built-in focus functions \code{\link{prob_logistic}} and \code{\link{mean_normal}} take an argument \code{X} giving covariate values defining the focus. This can either be a matrix or a vector, or a list or data frame that can be coerced into a matrix. 

If just one focus is needed, then \code{X} can be a vector of length equal to the number of parameters in the wide model.

To compute focused model comparison statistics for multiple focuses defined by the same focus function evaluated at multiple covariate values, \code{X} should be a matrix, with number of columns equal to the number of parameters in the wide model, and number of rows equal to the number of alternative focuses.

For a typical regression model, the first parameter will denote an intercept, so the first value of \code{X} should be 1, and the remaining values should correspond to covariates whose coefficients form parameters of the wide model.  See the examples in the vignette.

Arguments to the focus function other than \code{X} can also be supplied as a matrix, vector, list or data frame in the same way. An exception is when the argument is supplied as a vector, this is assumed to refer to multiple focuses.   For example, suppose the focus function defines the quantile of a distribution, and takes an argument \code{focus_p}, then calling \code{fic(...,focus_p=c(0.1, 0.9))} indicates two alternative focuses defined by the 0.1 and 0.9 quantiles.}
}
\value{
The returned data frame or array contains the following components, describing characteristics of the defined submodel.  See the package vignette for full, formal definitions, and Chapter 6 of Claeskens and Hjort, 2008.

\item{rmse}{The root mean square error of the estimate of the focus quantity.  Defined as the square root of (squared unadjusted bias plus variance).  This is an asymptotically unbiased estimator, but may occasionally be indeterminate if the estimate of the squared bias plus variance is negative.}

\item{rmse.adj}{The root mean square error, based on a bias estimator which is adjusted to avoid negative squared bias.  Defined on page 157 of Claeskens and Hjort as the sum of the variance and the squared adjusted bias.}

\item{bias}{The estimated bias of the focus quantity, adjusted to avoid negative squared bias.  This is defined as the square root of the quantity \eqn{sqb3(S)} from page 152 of Claeskens and Hjort, multiplied by the sign of the unadjusted bias. }

\item{se}{The estimated standard error (root variance) of the focus quantity.  Defined on page 157.}

\item{FIC}{The focused information criterion (equation 6.1 from Claeskens and Hjort), if \code{FIC=TRUE} was supplied. }


The object returned by \code{fic} also has the following attributes, which can be extracted with the \code{\link{attr}} function.

\item{iwide}{Index of the wide model in the vector of submodels, or \code{NULL} if the wide model is not included. }

\item{inarr}{Index of the narrow model in the vector of submodels, or \code{NULL} if the wide model is not included. }

\item{sub}{List of fitted submodel objects.}

\item{parnames}{Vector of names of parameters in the wide model.}

\item{inds}{Submodel indicators, as supplied in the \code{inds} argument.}
}
\description{
Focused information criteria for general models.  These methods estimate the bias and variance of estimates of a quantity of interest (the "focus") when smaller submodels are used in place of a "wide" model that is assumed to generate the data but may not give precise enough estimates.
}
\examples{

wide.glm <- glm(low ~ lwtkg + age + smoke + ht + ui + smokeage + smokeui,
                data=birthwt, family=binomial)
inds <- rbind(
              narrow = c(1,1,0,0,0,0,0,0),
              mod1 = c(1,1,1,1,0,0,0,0),
              wide = c(1,1,1,1,1,1,1,1)
)
vals.smoke <-    c(1, 58.24, 22.95, 1, 0, 0, 22.95, 0)
vals.nonsmoke <- c(1, 59.50, 23.43, 0, 0, 0, 0, 0)
X <- rbind("Smokers"=vals.smoke, "Non-smokers"=vals.nonsmoke)

fic(wide=wide.glm, inds=inds, focus="prob_logistic", X=X)

focus <- function(par, X)plogis(X \%*\% par)    
fic(wide=wide.glm, inds=inds, focus=focus, X=X)   # equivalent

}
\references{
Claeskens, G., & Hjort, N. L. (2008). Model selection and model averaging (Vol. 330). Cambridge: Cambridge University Press.

Claeskens, G., & Hjort, N. L. (2003). The focused information criterion. Journal of the American Statistical Association, 98(464), 900-916.
}
\keyword{models}
