% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_norway_map.R
\docType{data}
\name{norway_map_counties}
\alias{norway_map_counties}
\title{Maps of Norwegian Counties.}
\format{\describe{
\item{long}{Location code.}
\item{lat}{Location name.}
\item{order}{The order that this line should be plotted in.}
\item{hole}{Geodata. Not used.}
\item{piece}{Geodata. Not used.}
\item{group}{Needs to be used as 'group' aesthetic in ggplot2.}
\item{id}{Non-informative id code.}
\item{location_code}{Location code (county code).}
}}
\source{
\url{https://kartkatalog.geonorge.no/metadata/uuid/cb02ab77-d3e6-4500-8a92-ea67367e7734}
}
\usage{
norway_map_counties
}
\description{
We conveniently package map datasets for Norwegian counties
(taken from Geonorge) that can be used in ggplot2 without needing any geo
libraries. This data is licensed under Creative Commons 0.
}
\examples{
library(ggplot2)
q <- ggplot(mapping = aes(x = long, y = lat, group = group, fill = location_code))
q <- q + geom_polygon(data = fhidata::norway_map_counties, color = "black")
q <- q + theme_void()
q <- q + coord_quickmap()
q
}
\keyword{datasets}
