% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp_detectFFFMeanSinglePrechange}
\alias{cpp_detectFFFMeanSinglePrechange}
\title{Find the first changepoint in the mean using FFF, assuming prechange known}
\usage{
cpp_detectFFFMeanSinglePrechange(x, lambda, alpha, prechangeMean,
  prechangeSigma)
}
\arguments{
\item{x}{Vector of numeric values values.}

\item{lambda}{Value for the fixed forgetting factor in \eqn{(0,1)}.}

\item{alpha}{Value for the significance threshold in \eqn{(0,1)}.}

\item{prechangeMean}{Value of known prechange mean.}

\item{prechangeSigma}{Value of known prechange standard deviation.}
}
\value{
A list with 
\describe{
            \item{\code{tauhat}}{The index of the first changepoint found.}
         }
}
\description{
Given a vector \code{x}, a value \code{lambda}, a threshold \code{alpha},
and values for known prechange mean and variance, returns a list containing 
the single changepoint. Algorithm is implemented in C++.
}
\keyword{internal}

