% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mfl_playerscores.R
\name{ff_playerscores}
\alias{ff_playerscores}
\alias{ff_playerscores.mfl_conn}
\title{Get Player Scoring History}
\usage{
ff_playerscores(conn, season, week, ...)

\method{ff_playerscores}{mfl_conn}(conn, season, week, ...)
}
\arguments{
\item{conn}{the list object created by \code{ff_connect()}}

\item{season}{the season of interest - generally only the most recent 2-3 seasons are available}

\item{week}{a numeric or one of YTD (year-to-date) or AVG (average to date)}

\item{...}{other arguments (currently unused)}
}
\value{
A tibble of historical player scoring
}
\description{
This function returns a tibble of player scores based on league rules
}
\examples{
dlf_conn <- mfl_connect(2020, league_id = 37920)
ff_playerscores(conn = dlf_conn, season = 2019, week = "YTD")
}
