% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.feis}
\alias{predict.feis}
\title{Predict method for feis models}
\usage{
\method{predict}{feis}(
  object,
  newdata = NULL,
  se.fit = FALSE,
  vcov = NULL,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  pred.var = sigma_sq,
  ...
)
}
\arguments{
\item{object}{an object of class "\code{feis}", fitted model.}

\item{newdata}{an optional data frame in which to look for variables with which to predict.
If omitted, the fitted values are used.}

\item{se.fit}{a switch indicating if standard errors are required.}

\item{vcov}{optional variance-covariance matrix for std.err. calculation.}

\item{interval}{type of interval calculation.}

\item{level}{tolerance/confidence level.}

\item{pred.var}{the variance for future observations to be assumed for prediction intervals.
By default, equals the residual variance}

\item{...}{further arguments.}
}
\value{
A vector of predictions or a matrix of predictions and bounds with column names
\code{fit}, \code{lwr}, and \code{upr} if \code{interval} is set.
}
\description{
Predicted values based on linear model object.
}
\details{
\code{predict.lm} produces predicted values, obtained by evaluating the regression function
in the frame newdata (which defaults to \code{model.matrix(object)}). If the logical \code{se.fit} is
\code{TRUE}, standard errors of the predictions are calculated. If the \code{vcov} is not provided,
the \code{object$vcov} is used, thus allowing for robust variance-covariance matrices.
Setting intervals specifies computation of confidence or prediction (tolerance) intervals
at the specified \code{level}.

\bold{Note}: Currently, predictions are based on the transformed (de-trended) data.
}
\examples{
feis.mod <- feis(lnw ~ age | exp,
data = mwp, id = "id", robust = TRUE)

new <- data.frame(age = seq(-10, 10, 1))
feis.pred <- predict(feis.mod, newdata = new,
                     se.fit = TRUE, interval = "confidence")
matplot(new$age, feis.pred$fit, lty = c(1,2,2),
        type = "l", ylab = "predicted y")


}
\seealso{
\code{\link[stats]{predict.lm}, \link[stats]{predict}}
}
