% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{summary.feis}
\alias{summary.feis}
\title{Summary for feis objects}
\usage{
\method{summary}{feis}(object, vcov = NULL, ...)
}
\arguments{
\item{object}{an object of class "\code{plm}".}

\item{vcov}{a variance-covariance matrix furnished by the user or a function to calculate one.}

\item{...}{further arguments.}
}
\value{
An object of class "\code{summary.feis}", containing the elements
of the feis object (see \code{\link[feisr]{feis}}). The following objects
are modified:
\item{coefficients}{a matrix with the estimated coefficients, standard errors,
t-values, and p-values, if argument vcov is NULL the standard errors
are calculated by the \code{vcov} in the input object.}
\item{r.squared}{a vector containing R squared and adjusted R squared.}
}
\description{
The summary method for feis objects generates some additional information
about estimated feis models.
}
\examples{
data("mwp", package = "feisr")
feis.mod <- feis(lnw ~ marry | exp,
                 data = mwp, id = "id")
summary(feis.mod)
}
