% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feis.R
\name{slopes}
\alias{slopes}
\title{Extract individual slopes}
\usage{
slopes(model = NA, ...)
}
\arguments{
\item{model}{an object of class "\code{feis}".}

\item{...}{further arguments.}
}
\value{
An \code{N x J} matrix containing the individual slopes for each cluster unit \code{N}
and slope variable \code{J}. Rownames indicate the cluster id.
}
\description{
Extracts the individual slopes (\code{alpha_i}) from a \code{feis} object created by
\code{\link[feisr]{feis}}.
}
\details{
The function extracts a matrix containing the individual slope parameters (\code{alpha_i}),
which equals the coefficient(s) of regressing the depenent variable on the slope parameter(s).

If slope variables are perfectly collinear within a cluster, one variable is dropped
and the function returns \code{0} for the respective slope and cluster.
}
\examples{
data("Produc", package = "plm")
feis.mod <- feis("log(gsp) ~ log(pcap) + log(pc) + log(emp) + unemp | year",
                 data = Produc, id = "state", robust = TRUE)
slps <- slopes(feis.mod)
}
