% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_projects.R
\name{fe_projects}
\alias{fe_projects}
\title{Federal RePORTER projects}
\usage{
fe_projects(nih_id = NULL, internal_id = NULL, project_number = NULL,
  verbose = TRUE, secure = TRUE)
}
\arguments{
\item{nih_id}{global identifier for a project across all NIH
systems that handle research projects/grants data.
Example, 8828294.}

\item{internal_id}{internal Federal RePORTER generated unique ID
associated with each project. It is available as part of
export on Federal RePORTER search results. Example, 739576.}

\item{project_number}{unique number that is assigned to a project
by the affiliated federal agency. Examples: \code{'5R01MH092950-05'},
\code{'1R01CA183929-01A1'}, \code{'USFS-0000779'}.}

\item{verbose}{print diagnostic messages}

\item{secure}{passed to \code{\link{fe_base_url}} for https}
}
\value{
List of the result of the \code{\link{GET}} call and
the content
}
\description{
Federal RePORTER projects
}
\note{
See \url{https://api.federalreporter.nih.gov/#!/Projects/Get_Project}
}
\examples{
res = fe_projects(project_number = "5R01MH092950-05")
}
