% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{gg_season}
\alias{gg_season}
\title{Seasonal plot}
\usage{
gg_season(data, y = NULL, period = NULL, facet_period, max_col = 15,
  polar = FALSE, labels = c("none", "left", "right", "both"), ...)
}
\arguments{
\item{data}{A tidy time series object (tsibble)}

\item{y}{The variable to plot (a bare expression). If NULL, it will
automatically selected from the data.}

\item{period}{The seasonal period to display.}

\item{facet_period}{A secondary seasonal period to facet by
(typically smaller than period).}

\item{max_col}{The maximum number of colours to display on the plot. If the
number of seasonal periods in the data is larger than \code{max_col}, the plot
will not include a colour. Use \code{max_col = 0} to never colour the lines, or Inf
to always colour the lines. If labels are used, then max_col will be ignored.}

\item{polar}{If TRUE, the season plot will be shown on polar coordinates.}

\item{labels}{Position of the labels for seasonal period identifier.}

\item{...}{Additional arguments passed to geom_line()}
}
\value{
A ggplot object showing a seasonal plot of a time series.
}
\description{
Produces a time series seasonal plot. A seasonal plot is similar to a regular
time series plot, except the x-axis shows data from within each season. This
plot type allows the underlying seasonal pattern to be seen more clearly,
and is especially useful in identifying years in which the pattern changes.
}
\examples{
library(tsibble)
library(dplyr)
tsibbledata::aus_retail \%>\%
  filter(
    State == "Victoria",
    Industry == "Cafes, restaurants and catering services"
  ) \%>\%
  gg_season(Turnover)

}
\references{
Hyndman and Athanasopoulos (2019) Forecasting: principles and practice,
3rd edition, OTexts: Melbourne, Australia. https://OTexts.org/fpp3/
}
