% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_mean_bayes.R
\name{function_mean_bayes}
\alias{function_mean_bayes}
\title{Bayesian Karcher Mean Calculation}
\usage{
function_mean_bayes(f, time, times = 5, group = 1:dim(f)[2],
  showplot = TRUE)
}
\arguments{
\item{f}{matrix (\eqn{N} x \eqn{M}) of \eqn{M} functions with \eqn{N} samples}

\item{time}{sample points of functions}

\item{times}{factor of length of subsample points to look at (default = 5)}

\item{group}{(default 1:dim(f)[2])}

\item{showplot}{shows plots of functions (default = T)}
}
\value{
Returns a list containing \item{distfamily}{dist matrix}
\item{match.matrix}{matrix of warping functions}
\item{position}{position}
\item{mu_5}{function mean}
\item{rtmatrix}{rtmatrix}
\item{sumdist}{sumdist}
\item{qt.fitted}{aligned srsf functions}
\item{estimator}{estimator}
\item{estimator2}{estimator2}
\item{regfuncs}{registered functions}
}
\description{
This function calculates karcher mean of functions using Bayesian method
}
\examples{
\dontrun{
data("simu_data")
out = function_mean_bayes(simu_data$f, simu_data$time)
}
}
\references{
Cheng, W., Dryden, I. L., and Huang, X. (2016). Bayesian
registration of functions and curves. Bayesian Analysis, 11(2), 447-475.
}
\concept{srsf alignment}
\keyword{bayesian}
