% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeSparseGP.R
\name{MakeSparseGP}
\alias{MakeSparseGP}
\title{Make Gaussian Process Sparse Functional Data sample}
\usage{
MakeSparseGP(n, rdist = runif, sparsity = 2:9, muFun = function(x) rep(0,
  length(x)), K = 2, lambda = rep(1, K), sigma = 0, basisType = "cos",
  CovFun = NULL)
}
\arguments{
\item{n}{number of samples to generate.}

\item{rdist}{a sampler for generating the random design time points within [0, 1].}

\item{sparsity}{A vector of integers. The number of observation per sample is chosen to be one of the elements in sparsity with equal chance.}

\item{muFun}{a function that takes a vector input and output a vector of the corresponding mean (default: zero function).}

\item{K}{scalar specifying the number of basis to be used (default: 2).}

\item{lambda}{vector of size K specifying the variance of each components (default: rep(1,K)).}

\item{sigma}{The standard deviation of the Gaussian noise added to each observation points.}

\item{basisType}{string specifiying the basis type used; possible options are: 'sin', 'cos' and 'fourier' (default: 'cos') (See code of 'CreateBasis' for implementation details.)}

\item{CovFun}{an alternative specification of the covariance structure.}
}
\value{
TODO
}
\description{
Make a Gaussian process sparse functional data sample of size n
}

