% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-kma.R
\name{plot.kma}
\alias{plot.kma}
\title{Plot for \code{kmap} objects}
\usage{
\method{plot}{kma}(x, type = "data", number_of_displayed_points = 50, ...)
}
\arguments{
\item{x}{The \link{kma} object to be plotted.}

\item{type}{A string specifying the type of information to display. Choices
are \code{"data"} for plotting the original and aligned curves (default) or
\code{"warping"} for plotting the corresponding warping functions.}

\item{number_of_displayed_points}{The number of points to used for display.
It is set as the minimum between this parameter and the number of points in
the original data set. Defaults to 50.}

\item{...}{Other graphical parameters (see \link[graphics:par]{par}). Ignored for
now.}
}
\value{
A \link[ggplot2:ggplot]{ggplot} object invisibly.
}
\description{
Plot for \code{kmap} objects
}
\examples{
res <- kma(
  simulated30$x,
  simulated30$y,
  seeds = c(1, 21),
  n_clust = 2,
  center_method = "medoid",
  warping_method = "affine",
  dissimilarity_method = "pearson"
)

plot(res, type = "data")
plot(res, type = "warping")
}
