% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testFunctions.R
\name{fs.test.3D}
\alias{fs.test.3D}
\title{FELSPLINE 3D test function}
\usage{
fs.test.3D(x, y, z, r0 = 0.25, r = 1.25, l = 5, b = 1, exclude = FALSE)
}
\arguments{
\item{x, y, z}{Points at which to evaluate the test function.}

\item{r0}{The test domain is a sort of bent sausage. This is the radius of the inner bend.}

\item{r}{The radius of the curve at the centre of the sausage.}

\item{l}{The length of an arm of the sausage.}

\item{b}{The rate at which the function increases per unit increase in distance along the centre line of the sausage.}

\item{exclude}{Should exterior points be set to NA?}
}
\value{
Returns function evaluations, or NAs for points outside the horseshoe domain.
}
\description{
Implements a finite area test function based on one proposed by Tim Ramsay (2002) and by 
Simon Wood (2008) in 3D.
}
\examples{
library(fdaPDE)

data(horseshoe2.5D)
mesh = horseshoe2.5D
FEMbasis=create.FEM.basis(mesh)

# Evaluation at nodes
sol_exact=fs.test.3D(mesh$nodes[,1],mesh$nodes[,3],mesh$nodes[,2])
plot(FEM(sol_exact, FEMbasis))
}
